*Syntax to create variable labels and value labels for 2008 Drinking and Driving Survey data set and run freqs.

Variable Labels    STATE  'State' .
Execute.

value labels   State
      1 'Alabama - S'  
      2 'Alaska - W'  
      4 'Arizona - W'  
      5 'Arkansas - S'  
      6 'California - W'  
      8 'Colorado - W'  
      9 'Connecticut - NE'  
      10 'Delaware - S'  
      11 'Washington D.C. - S'  
      12 'Florida - S'  
      13 'Georgia - S'  
      15 'Hawaii - W'  
      16  'Idaho - W'  
      17  'Illinois - MW'  
      18  'Indiana - MW'  
      19 'Iowa - MW'  
      20 'Kansas - MW'  
      21 'Kentucky - S'  
      22  'Louisiana - S'  
      23  'Maine - NE'  
      24  'Maryland - S'  
      25  'Massachusetts - NE'  
      26  'Michigan - MW'  
      27  'Minnesota - MW'  
      28  'Mississippi - S'  
      29  'Missouri - NC'  
      30  'Montana - W'  
      31  'Nebraska - MW'  
      32  'Nevada - W'  
      33  'New Hampshire - NE'  
      34  'New Jersey - NE'  
      35  'New Mexico - W'  
      36  'New York - NE'  
      37  'North Carolina - S'  
      38  'North Dakota - MW'  
      39  'Ohio - MW'  
      40  'Oklahoma - S'  
      41  'Oregon - W'  
      42  'Pennsylvania - NE'  
      44  'Rhode Island - NE'  
      45  'South Carolina - S'  
      46  'South Dakota - MW'  
      47  'Tennessee - S'  
      48  'Texas - SC'  
      49  'Utah - W'  
      50  'Vermont - NE'  
      51  'Virginia - S'  
      53  'Washington - W'  
      54  'West Virginia - S'  
      55  'Wisconsin - MW'  
      56  'Wyoming - W'  .

Variable Labels    
     QNSA1  'Source'.
Execute.

value labels  
      QNSA1     1  'RDD'        
                      2  'CELL'  .
      
Variable Labels             REGION 'Region'.
Execute.

value labels     REGION 
      1  'NE'  
      2  'MW'  
      3  'S'  
      4  'W' .
Execute.  

* Freq  var = Source / Stats=all.
*DATASET ACTIVATE DataSet1.
FREQUENCIES VARIABLES=STATE QNSA1 REGION
  /ORDER=ANALYSIS.

variable labels  QNS1 'S1 Including yourself how many members of this household are age 16 or older?'.
Execute.

value labels  QNS1 
      0  'None'  
      6  '6 or more'  
      97  'Not available'  
      98  'Don''t know'  
      99= 'Refused' .
Execute. 

variable labels  QNS3A 'Gender'.
Execute.

Value labels QNS3A 
      1  'Male'  
      2  'Female' .
Execute.

FREQUENCIES VARIABLES= QNS1  QNS3A
  /ORDER=ANALYSIS.

variable labels   QN1  'Q1 How often do you usually drive a car or other motor vehicle?'.
Execute.

value labels QN1
      1  'Every day'  
      2  'Several days a week'  
      3  'Once a week or less'  
      4  'Only certain times a year'  
      5  'Never'  
      6  'Don''t know'  
      7  'Refused' .
Execute.

variable labels QN15  'Q15 During the last twelve months how often did you usually drink any alcoholic beverages including beer light beer wine wine coolers liquor or flavored malt beverages?'.     
Execute.

Value labels  QN15 
      1  'Every day'  
      2  'Nearly every day'  
      3  'Three or four days a week'  
      4  'One or two days a week'  
      5  'Two or three days a month'  
      6  'Once a month or less'  
      7  'You never drank alcoholic beverages in last twelve month'  
      8  'Don''t know'  
      9  'Refused' .

FREQUENCIES VARIABLES= QN1  QN15
  /ORDER=ANALYSIS.

Variable labels QN17  'Q17 When you drink alcoholic beverages which ONE of the following beverages do you drink MOST OFTEN?'.
Execute.
Value Labels QN17 
      1  'OR, something else'  
      2  'Don''t know'  
      3  'Refused'  
      6  'Beer'  
      7  'Light beer'  
      8  'Wine'  
      9  'Wine coolers'  
      10  'Hard liquor or mixed drinks'  
      11  'Flavored malt drinks' .
Execute.

VARIABLE LABELS QN18  'Q18. When you drink ANSWER FROM (QN17R1), about how many ANSWER FROM (QN17R2) do you usually drink per sitting?'.
Execute.
value Labels  QN18 
      96  '96+'  
      97  'Less than one'  
      98  'Don''t know'  
      99  'Refused' .
Execute.

FREQUENCIES VARIABLES= QN17  QN18
  /ORDER=ANALYSIS.

VARIABLE LABELS QN19A '19a About how old were you when you first starting drinking alcohol, not counting small tastes or sips of alcohol?'.
Execute.
VALUE LABELS QN19A 
      96  '96 years or older'  
      97  'Never drink/drank'  
      98  'Don''t know'  
      99  'Refused' .
Execute.

VARIABLE LABELS qn20 'Q20 On how many of the thirty days in this typical month did you have one or more alcoholic beverages to drink?'.
Execute.
VALUE LABELS qn20
        0  'None'  
      30  'Every day'  
      98  'DK'  
      99  'RF' .
Execute.

VARIABLE LABELS qn23 'Q23. On how many of the ANSWER FROM (QN20) days did you have five or more drinks?'.
Execute.
VALUE LABELS qn23
       0  'None'  
      98  'DK'  
      99  'RF' .
Execute.

VARIABLE LABELS QN26 
'Q26 During the last 12 months, has there been a time when you felt you should cut down on your drinking?'.
VALUE LABELS QN26
      1  'Yes'  
      2  'No'  
      3  'Don''t know'  
      4  'Refused' .
Execute.

FREQUENCIES VARIABLES= QN19A  qn20 qn23 QN26
  /ORDER=ANALYSIS.


